/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.core;

import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public final class DescriptionContainer {
    private final SkillType<?> type;
    private final List<Property> properties = new ArrayList<Property>();

    public DescriptionContainer(SkillType<?> type) {
        this.type = type;
    }

    public void addProperty(String propertyTag, Object ... props) {
        this.properties.add(new Property(propertyTag, props));
    }

    public ITextComponent[] getLines() {
        ITextComponent[] components = new ITextComponent[this.properties.size()];
        int index = 0;
        for (Property property : this.properties) {
            components[index++] = SkillUtil.Localizations.translation(this.type, property.tag, property.props);
        }
        return components;
    }

    private static class Property {
        private final String tag;
        private final Object[] props;

        public Property(String tag, Object[] props) {
            this.tag = tag;
            this.props = props;
        }
    }
}

